/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xlatrdef.h
 *       trace memory trigger definitions
 * -----------------------------------------------------------------*/

#ifndef XLATRDEFS_H
#define XLATRDEFS_H

/* Number of generic properties for each sequencer */
#define BX_TRIGGEN_SIZE 2

CLI typedef enum {
  BX_TRIGGEN_FBA,     /* @fba  */
  BX_TRIGGEN_FBB      /* @fbb  */
} bx_triggentype;


/* integer based trigger sequencer transient properties */

/* Number of transients per line */
#define BX_TRIGLINETRAN_SIZE  2 /* current, nextstate; may NEVER exceed 4 (Robert Siegmund) */

CLI typedef enum {
  BX_TRIGTRAN_STATE     =0,          /* @state     */
  BX_TRIGTRAN_NEXTSTATE =1           /* @nextstate */
} bx_trigtrantype;

/* Number of conditions per line */
#define BX_TRIGLINECOND_SIZE  7 

CLI typedef enum {
  BX_TRIGCOND_X,         /* @x         */
  BX_TRIGCOND_TRIG,      /* @trig      */
  BX_TRIGCOND_SQ,        /* @sq        */
  BX_TRIGCOND_FBADEC,    /* @fbadec    */
  BX_TRIGCOND_FBALOAD,   /* @fbaload   */
  BX_TRIGCOND_FBBDEC,    /* @fbbdec    */
  BX_TRIGCOND_FBBLOAD    /* @fbbload   */
} bx_trigcondtype;

/* this define is NOT to be changed and reflects the offset the properties
   for the sequencer conditions are increased (a Robert Siegmund hack) */
#define BX_TRIG_CONDITION_OFFSET   4 /* chris TBD check and change */

#endif
